﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using Microsoft.SharePoint.Client;

namespace SilverlightApplication
{
   public partial class MainPage : UserControl
   {
      private IEnumerable<List> _Lists;
      private delegate void UpdateUiMethod();

      public MainPage()
      {
         InitializeComponent();
         this.Loaded += UserControlLoaded;
      }

      private void UserControlLoaded(object sender, RoutedEventArgs e)
      {
         ClientContext clientContext = ClientContext.Current;
         Web web = clientContext.Web;
         ListCollection lists = web.Lists;
         clientContext.Load(web, website => website.Title);

         _Lists = clientContext.LoadQuery(lists.Include(list => list.Title));
         clientContext.ExecuteQueryAsync(OnQuerySucceeded, OnQueryFailed);
      }

      private void OnQuerySucceeded(object sender, ClientRequestSucceededEventArgs args)
      {
         UpdateUiMethod updateUi = DisplayInfo;
         Dispatcher.BeginInvoke(updateUi);
      }

      private void DisplayInfo()
      {
         foreach (List list in _Lists)
         {
            textBlock.Text += list.Title + Environment.NewLine;
         }
      }

      private void OnQueryFailed(object sender, ClientRequestFailedEventArgs args)
      {
         Dispatcher.BeginInvoke(delegate
                                   {
                                      textBlock.Text = string.Format("Request failed. {0}\n{1}", args.Message,
                                                                     args.StackTrace);
                                   });
      }

      private void button1_Click(object sender, RoutedEventArgs e)
      {
         textBlock.Text = DateTime.Now.ToLongTimeString();
      }
   }
}
